/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Invoice;
import itx.erp.sales.model.Order;
import itx.erp.sales.model.OrderLine;
import itx.erp.sales.model.Vat;
import itx.erp.sales.pdf.OrderPdf;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.InvoiceService;
import itx.erp.sales.service.OrderService;
import itx.erp.sales.validator.OrderValidator;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.ProcUtil;

public class OrderController
extends BaseController {
    protected ErpConfig appConfig;
    protected OrderService orderService;
    protected InvoiceService invoiceService;
    protected ArticleService articleService;
    protected SalesSettings salesSettings;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<Order> qrs = this.orderService.searchOrders(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("salesSettings", this.salesSettings);
        result.put("orders", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer oid = req.getParamInt("orderId");
        Order o = this.orderService.readOrder(oid);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("order", o);
        List<Invoice> invoices = this.invoiceService.listByOrder(o.getOrderId());
        result.put("invoices", invoices);
        List<Invoice> invoicesByOffers = this.invoiceService.invoicesFromOffersOfOrder(o.getOrderId());
        result.put("invoicesByOffers", invoicesByOffers);
        req.renderJson(result);
    }

    public void configAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Vat> vats = this.articleService.readVats();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("salesSettings", this.salesSettings);
        result.put("vats", vats);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer orderId = req.getParamInt("orderId");
        Order o = orderId != null ? this.orderService.readOrder(orderId) : new Order();
        o.setOrderDate(req.getParamDate("orderDate"));
        o.setCustomerId(req.getParamInt("customerId"));
        o.setOrderStatus(req.getParameter("orderStatus"));
        o.setSubject(req.getParameter("subject"));
        o.setComment(req.getParameter("comment"));
        o.setInternalNote(req.getParameter("internalNote"));
        List<KeyValueList> lines = req.getKvl().getList("lines");
        o.getLines().clear();
        int cnt = 0;
        for (KeyValueList l : lines) {
            Vat v;
            String lineType = l.getValue("lineType");
            OrderLine ol = new OrderLine();
            ol.setLineType(lineType);
            ol.setSort(cnt++);
            if ("text".equals(lineType)) {
                ol.setShortDescription(l.getValue("shortDescription"));
                ol.setShortDescription2(l.getValue("shortDescription2"));
            }
            if ("price".equals(lineType)) {
                ol.setShortDescription(l.getValue("shortDescription"));
                ol.setAmount(l.getValueDouble("amount"));
                ol.setVatPercentage(l.getValueDouble("vatPercentage"));
                v = new Vat();
                v.setPercentage(ol.getVatPercentage());
                if (this.salesSettings.inputPriceExclVat()) {
                    ol.setPriceExclVat(l.getValueDouble("price"));
                    ol.setPriceInclVat(v.addVat(ol.getPriceExclVat()));
                } else {
                    ol.setPriceInclVat(l.getValueDouble("price"));
                    ol.setPriceExclVat(v.subtractVat(ol.getPriceInclVat()));
                }
            }
            if ("article".equals(lineType)) {
                ol.setArticleId(l.getValueInt("articleId"));
                ol.setSlotplanPricetypeId(l.getValueInt("pricetypeId"));
                ol.setShortDescription(l.getValue("shortDescription"));
                ol.setAmount(l.getValueDouble("amount"));
                ol.setVatPercentage(l.getValueDouble("vatPercentage"));
                v = new Vat();
                v.setPercentage(ol.getVatPercentage());
                if (this.salesSettings.inputPriceExclVat()) {
                    ol.setPriceExclVat(l.getValueDouble("price"));
                    ol.setPriceInclVat(v.addVat(ol.getPriceExclVat()));
                } else {
                    ol.setPriceInclVat(l.getValueDouble("price"));
                    Double piv = ol.getPriceInclVat();
                    Double pev = v.subtractVat(piv);
                    ol.setPriceExclVat(pev);
                }
            }
            o.getLines().add(ol);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        OrderValidator validator = new OrderValidator();
        if (validator.validate(o)) {
            orderId = this.orderService.saveOrder(o);
            result.put("orderId", orderId);
            result.put("success", true);
        } else {
            result.put("error", true);
            result.put("errors", validator.getErrors());
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer id = req.getParamInt("orderId");
        this.orderService.deleteOrder(id);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void printAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer orderId = req.getParamInt("id");
        Order o = this.orderService.readOrder(orderId);
        OrderPdf pdf = new OrderPdf(o);
        HttpServletResponse resp = req.getResponse();
        resp.setContentType("application/pdf");
        resp.setHeader("Content-Disposition", "inline; filename=\"order-" + String.valueOf(orderId) + ".pdf\"");
        ServletOutputStream os = resp.getOutputStream();
        pdf.save((OutputStream)os);
        os.close();
    }

    public void openOrderAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        if (!this.appConfig.isDesktopMode()) {
            throw new InvalidStateException("Not in desktop mode");
        }
        Integer orderId = req.getParamInt("id");
        Order o = this.orderService.readOrder(orderId);
        OrderPdf pdf = new OrderPdf(o);
        String d = ErpObjectContainer.getInstance().getDataDir() + "/orders";
        File orderDir = new File(d);
        if (!orderDir.exists()) {
            orderDir.mkdir();
        }
        String p = orderDir.getAbsolutePath() + "/order-" + String.valueOf(o.getOrderId()) + ".pdf";
        pdf.save(p);
        ProcUtil.openUrlInBrowser(p);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void createInvoiceAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer orderId = req.getParamInt("orderId");
        Order ord = this.getOrderService().readOrder(orderId);
        Invoice i = this.invoiceService.createInvoice(ord);
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("success", Boolean.valueOf(true));
        result.put("invoiceId", i.getInvoiceId());
        req.renderJson(result);
    }
}

